#!/bin/sh
################################################################################
# Install the BESAgent from a built installer image
#
# This script basically does what double clicking on the package would do, but
# without the UI.  Installs to the root volume.
################################################################################
if [ $# -ne 1 ]; then
	echo "Usage: InstallBESAgent.sh installImage"
	exit 1
fi

instImage="$1"

# Mount the installation image and save its volume location (needed to copy
# files from it) and disk (needed to unmount it)
mountLine=`hdiutil attach "$instImage" | tail -n 1`
disk=`expr "$mountLine" : '\([^ ]*\).*$'`
volLoc=`expr "$mountLine" : '[^ ]*[^\/]*\(.*\)$'`

# remove any previous package and masthead from the /tmp dir, in case we fail to
# copy from our disk image.  We don't want to install an old version without
# knowing it.
rm -rf "/tmp/BESAgent.pkg"
#rm -f "/tmp/actionsite.afxm"

# copy the package and masthead to the tmp directory.  The installer expects
# to find the masthead in a previous installation, or next to the package
# if there is no previous installation.
cp -rf "$volLoc/BESAgent.pkg" /tmp
cp -f "$volLoc/actionsite.afxm" /tmp

# Now that we have copied the files to /tmp we can unmount the dist image
hdiutil detach -force "$disk"

# Now run the installer on the package
installer -pkg "/tmp/BESAgent.pkg" -target /

